<?php 
class GTVC_Customize {
   /**
    * This hooks into 'customize_register' (available as of WP 3.4) and allows
    * you to add new sections and controls to the Theme Customize screen.
    * 
    * Note: To enable instant preview, we have to actually write a bit of custom
    * javascript. See live_preview() for more.
    *  
    * @see add_action('customize_register',$func)
    * @param \WP_Customize_Manager $wp_customize
    * @link http://ottopress.com/2012/how-to-leverage-the-theme-customizer-in-your-own-themes/
    * @since gtvc 1.0
    */
   public static function register ( $wp_customize ) {
      //1. Define a new section (if desired) to the Theme Customizer
    

      $wp_customize->add_panel( 'gtvc_panel', 
         array(
            'title'       => __( 'Gaming Topup Options', 'gtvc' ), //Visible title of section
            'priority'    => 35, //Determines what order this appears in
            'capability'  => 'edit_theme_options', //Capability needed to tweak
         ) 
      );

      //Section Product Grid/List
      $wp_customize->add_section( 'gtvc_options', 
         array(
            'title'       => __( 'Product Grid/ List', 'gtvc' ), //Visible title of section
            'priority'    => 10, //Determines what order this appears in
            'capability'  => 'edit_theme_options', //Capability needed to tweak
            'description' => __('To Change Product Items & Grid Options', 'gtvc'), //Descriptive tooltip
            'panel'=>'gtvc_panel',
         ) 
      );


      
      //Product Loop Border Size
      $wp_customize->add_setting( 'gtvc_product_loop_border_size', //No need to use a SERIALIZED name, as `theme_mod` settings already live under one db record
         array(
            'default'    => '3', //Default setting/value to save
            'capability' => 'edit_theme_options', //Optional. Special permissions for accessing this setting.
            'transport'  => 'refresh', //What triggers a refresh of the setting? 'refresh' or 'postMessage' (instant)?
         ) 
      );      
            
      //3. Finally, we define the control itself (which links a setting to a section and renders the HTML controls)...
      $wp_customize->add_control( 'gtvc_product_loop_border_size_control', array(
        'type' => 'number',
        'settings'   => 'gtvc_product_loop_border_size', 
        'section' => 'gtvc_options', // Add a default or your own section
        'label' => __( 'Border Size (px)', 'gtvc' ),
        ) );


        //2. Loop Border Redius
      $wp_customize->add_setting( 'gtvc_product_loop_border_radius', //No need to use a SERIALIZED name, as `theme_mod` settings already live under one db record
         array(
            'default'    => '10', //Default setting/value to save
            'capability' => 'edit_theme_options', //Optional. Special permissions for accessing this setting.
            'transport'  => 'refresh', //What triggers a refresh of the setting? 'refresh' or 'postMessage' (instant)?
         ) 
      );      
            
      //3. Finally, we define the control itself (which links a setting to a section and renders the HTML controls)...
      $wp_customize->add_control( 'gtvc_product_loop_border_radius_control', array(
        'type' => 'number',
        'settings'   => 'gtvc_product_loop_border_radius', 
        'section' => 'gtvc_options', // Add a default or your own section
        'label' => __( 'Border Radius (px)', 'gtvc' ),
        ) );


        //2. Image Border Redius Top
      $wp_customize->add_setting( 'gtvc_product_image_border_radius_top', //No need to use a SERIALIZED name, as `theme_mod` settings already live under one db record
         array(
            'default'    => '10', //Default setting/value to save
            'capability' => 'edit_theme_options', //Optional. Special permissions for accessing this setting.
            'transport'  => 'refresh', //What triggers a refresh of the setting? 'refresh' or 'postMessage' (instant)?
         ) 
      );      
            
      //3. Finally, we define the control itself (which links a setting to a section and renders the HTML controls)...
      $wp_customize->add_control( 'gtvc_product_image_border_radius_top_control', array(
        'type' => 'number',
        'settings'   => 'gtvc_product_image_border_radius_top', 
        'section' => 'gtvc_options', // Add a default or your own section
        'label' => __( 'Image Border Radius (Top-Px)', 'gtvc' ),
        ) );


        //2. Image Border Redius Bottom
      $wp_customize->add_setting( 'gtvc_product_image_border_radius_bottom', //No need to use a SERIALIZED name, as `theme_mod` settings already live under one db record
         array(
            'default'    => '0', //Default setting/value to save
            'capability' => 'edit_theme_options', //Optional. Special permissions for accessing this setting.
            'transport'  => 'refresh', //What triggers a refresh of the setting? 'refresh' or 'postMessage' (instant)?
         ) 
      );      
            
      //3. Finally, we define the control itself (which links a setting to a section and renders the HTML controls)...
      $wp_customize->add_control( 'gtvc_product_image_border_radius_bottom_control', array(
        'type' => 'number',
        'settings'   => 'gtvc_product_image_border_radius_bottom', 
        'section' => 'gtvc_options', // Add a default or your own section
        'label' => __( 'Image Border Radius (Bottom-Px)', 'gtvc' ),
        ) );



        //2. Loop Margin & Column Gap
      $wp_customize->add_setting( 'gtvc_product_loop_margin', //No need to use a SERIALIZED name, as `theme_mod` settings already live under one db record
         array(
            'default'    => '10', //Default setting/value to save
            'capability' => 'edit_theme_options', //Optional. Special permissions for accessing this setting.
            'transport'  => 'refresh', //What triggers a refresh of the setting? 'refresh' or 'postMessage' (instant)?
         ) 
      );      
            
      //3. Finally, we define the control itself (which links a setting to a section and renders the HTML controls)...
      $wp_customize->add_control( 'gtvc_product_loop_margin_control', array(
        'type' => 'number',
        'settings'   => 'gtvc_product_loop_margin', 
        'section' => 'gtvc_options', // Add a default or your own section
        'label' => __( 'Margin & Gap (px)', 'gtvc' ),
        ) );

        //2. Loop Content Padding
      $wp_customize->add_setting( 'gtvc_product_content_padding', //No need to use a SERIALIZED name, as `theme_mod` settings already live under one db record
         array(
            'default'    => '10', //Default setting/value to save
            'capability' => 'edit_theme_options', //Optional. Special permissions for accessing this setting.
            'transport'  => 'refresh', //What triggers a refresh of the setting? 'refresh' or 'postMessage' (instant)?
         ) 
      );      
            
      //3. Finally, we define the control itself (which links a setting to a section and renders the HTML controls)...
      $wp_customize->add_control( 'gtvc_product_content_padding_control', array(
        'type' => 'number',
        'settings'   => 'gtvc_product_content_padding', 
        'section' => 'gtvc_options', // Add a default or your own section
        'label' => __( 'Content Padding (px)', 'gtvc' ),
        ) );
      
      //2. Product loop Title Color
      $wp_customize->add_setting( 'gtvc_product_loop_title_color', //No need to use a SERIALIZED name, as `theme_mod` settings already live under one db record
         array(
            'default'    => '#000', //Default setting/value to save
            'capability' => 'edit_theme_options', //Optional. Special permissions for accessing this setting.
            'transport'  => 'refresh', //What triggers a refresh of the setting? 'refresh' or 'postMessage' (instant)?
         ) 
      );      
            
      //3. Finally, we define the control itself (which links a setting to a section and renders the HTML controls)...
      $wp_customize->add_control( new WP_Customize_Color_Control( //Instantiate the color control class
         $wp_customize, //Pass the $wp_customize object (required)
         'gtvc_product_loop_title_color_control', //Set a unique ID for the control
         array(
            'label'      => __( 'Product Title Color', 'gtvc' ), //Admin-visible name of the control
            'settings'   => 'gtvc_product_loop_title_color', //Which setting to load and manipulate (serialized is okay)
            'section'    => 'gtvc_options', //ID of the section this control should render in (can be one of yours, or a WordPress default section)
         ) 
      ) );

        //2. Loop Border Color
      $wp_customize->add_setting( 'gtvc_product_loop_border_color', //No need to use a SERIALIZED name, as `theme_mod` settings already live under one db record
         array(
            'default'    => '#ffd000', //Default setting/value to save
            'capability' => 'edit_theme_options', //Optional. Special permissions for accessing this setting.
            'transport'  => 'refresh', //What triggers a refresh of the setting? 'refresh' or 'postMessage' (instant)?
         ) 
      );      
            
      //3. Finally, we define the control itself (which links a setting to a section and renders the HTML controls)...
      $wp_customize->add_control( new WP_Customize_Color_Control( //Instantiate the color control class
         $wp_customize, //Pass the $wp_customize object (required)
         'gtvc_product_loop_border_color_control', //Set a unique ID for the control
         array(
            'label'      => __( 'Border Color', 'gtvc' ), //Admin-visible name of the control
            'settings'   => 'gtvc_product_loop_border_color', //Which setting to load and manipulate (serialized is okay)
            'section'    => 'gtvc_options', //ID of the section this control should render in (can be one of yours, or a WordPress default section)
         ) 
      ) );

         //2. Loop Background Color
      $wp_customize->add_setting( 'gtvc_product_loop_bg_color', //No need to use a SERIALIZED name, as `theme_mod` settings already live under one db record
         array(
            'default'    => '#fff', //Default setting/value to save
            'capability' => 'edit_theme_options', //Optional. Special permissions for accessing this setting.
            'transport'  => 'refresh', //What triggers a refresh of the setting? 'refresh' or 'postMessage' (instant)?
         ) 
      );      
            
      //3. Finally, we define the control itself (which links a setting to a section and renders the HTML controls)...
      $wp_customize->add_control( new WP_Customize_Color_Control( //Instantiate the color control class
         $wp_customize, //Pass the $wp_customize object (required)
         'gtvc_product_loop_bg_color_control', //Set a unique ID for the control
         array(
            'label'      => __( 'Content Background Color', 'gtvc' ), //Admin-visible name of the control
            'settings'   => 'gtvc_product_loop_bg_color', //Which setting to load and manipulate (serialized is okay)
            'section'    => 'gtvc_options', //ID of the section this control should render in (can be one of yours, or a WordPress default section)
         ) 
      ) );


      //2. Category Text Color Inner Loop
      $wp_customize->add_setting( 'gtvc_category_text_color', //No need to use a SERIALIZED name, as `theme_mod` settings already live under one db record
         array(
            'default'    => '#000', //Default setting/value to save
            'capability' => 'edit_theme_options', //Optional. Special permissions for accessing this setting.
            'transport'  => 'refresh', //What triggers a refresh of the setting? 'refresh' or 'postMessage' (instant)?
         ) 
      );      
            
      //3. Finally, we define the control itself (which links a setting to a section and renders the HTML controls)...
      $wp_customize->add_control( new WP_Customize_Color_Control( //Instantiate the color control class
         $wp_customize, //Pass the $wp_customize object (required)
         'gtvc_category_text_color_control', //Set a unique ID for the control
         array(
            'label'      => __( 'Category Text Color', 'gtvc' ), //Admin-visible name of the control
            'settings'   => 'gtvc_category_text_color', //Which setting to load and manipulate (serialized is okay)
            'section'    => 'gtvc_options', //ID of the section this control should render in (can be one of yours, or a WordPress default section)
         ) 
      ) );


      //2. Category Text Bg Color Inner Loop
      $wp_customize->add_setting( 'gtvc_cat_text_bg_color', //No need to use a SERIALIZED name, as `theme_mod` settings already live under one db record
         array(
            'default'    => '#ffd000', //Default setting/value to save
            'capability' => 'edit_theme_options', //Optional. Special permissions for accessing this setting.
            'transport'  => 'refresh', //What triggers a refresh of the setting? 'refresh' or 'postMessage' (instant)?
         ) 
      );      
            
      //3. Finally, we define the control itself (which links a setting to a section and renders the HTML controls)...
      $wp_customize->add_control( new WP_Customize_Color_Control( //Instantiate the color control class
         $wp_customize, //Pass the $wp_customize object (required)
         'gtvc_menu_text_bg_color_control', //Set a unique ID for the control
         array(
            'label'      => __( 'Category Background', 'gtvc' ), //Admin-visible name of the control
            'settings'   => 'gtvc_cat_text_bg_color', //Which setting to load and manipulate (serialized is okay)
            'section'    => 'gtvc_options', //ID of the section this control should render in (can be one of yours, or a WordPress default section)
         ) 
      ) );


      //Product Category Settings & Controls///
      /////////////////////////////////////////

      //Section Product Category
      $wp_customize->add_section( 'gtvc_category_options', 
         array(
            'title'       => __( 'Product Category Grid', 'gtvc' ), //Visible title of section
            'priority'    => 10, //Determines what order this appears in
            'capability'  => 'edit_theme_options', //Capability needed to tweak
            'description' => __('To Change Product Category Grid Options', 'gtvc'), //Descriptive tooltip
            'panel'=>'gtvc_panel',
         ) 
      );
      
      //2. Category Loop Title Color
      $wp_customize->add_setting( 'gtvc_category_loop_title_color', //No need to use a SERIALIZED name, as `theme_mod` settings already live under one db record
         array(
            'default'    => '#000', //Default setting/value to save
            'capability' => 'edit_theme_options', //Optional. Special permissions for accessing this setting.
            'transport'  => 'refresh', //What triggers a refresh of the setting? 'refresh' or 'postMessage' (instant)?
         ) 
      );      
            
      //3. Finally, we define the control itself (which links a setting to a section and renders the HTML controls)...
      $wp_customize->add_control( new WP_Customize_Color_Control( //Instantiate the color control class
         $wp_customize, //Pass the $wp_customize object (required)
         'gtvc_category_loop_title_color_control', //Set a unique ID for the control
         array(
            'label'      => __( 'Category Title Color', 'gtvc' ), //Admin-visible name of the control
            'settings'   => 'gtvc_category_loop_title_color', //Which setting to load and manipulate (serialized is okay)
            'section'    => 'gtvc_category_options', //ID of the section this control should render in (can be one of yours, or a WordPress default section)
         ) 
      ) );

      //2. Category Text Bg Color Inner Loop
      $wp_customize->add_setting( 'gtvc_category_loop_count_color', //No need to use a SERIALIZED name, as `theme_mod` settings already live under one db record
         array(
            'default'    => '#f40000', //Default setting/value to save
            'capability' => 'edit_theme_options', //Optional. Special permissions for accessing this setting.
            'transport'  => 'refresh', //What triggers a refresh of the setting? 'refresh' or 'postMessage' (instant)?
         ) 
      );      
            
      //3. Finally, we define the control itself (which links a setting to a section and renders the HTML controls)...
      $wp_customize->add_control( new WP_Customize_Color_Control( //Instantiate the color control class
         $wp_customize, //Pass the $wp_customize object (required)
         'gtvc_category_loop_count_color_control', //Set a unique ID for the control
         array(
            'label'      => __( 'Category Count Color', 'gtvc' ), //Admin-visible name of the control
            'settings'   => 'gtvc_category_loop_count_color', //Which setting to load and manipulate (serialized is okay)
            'section'    => 'gtvc_category_options', //ID of the section this control should render in (can be one of yours, or a WordPress default section)
         ) 
      ) );

      //2. Category Grid Background Color
      $wp_customize->add_setting( 'gtvc_category_loop_bg_color', //No need to use a SERIALIZED name, as `theme_mod` settings already live under one db record
         array(
            'default'    => '#FFD000', //Default setting/value to save
            'capability' => 'edit_theme_options', //Optional. Special permissions for accessing this setting.
            'transport'  => 'refresh', //What triggers a refresh of the setting? 'refresh' or 'postMessage' (instant)?
         ) 
      );      
            
      //3. Finally, we define the control itself (which links a setting to a section and renders the HTML controls)...
      $wp_customize->add_control( new WP_Customize_Color_Control( //Instantiate the color control class
         $wp_customize, //Pass the $wp_customize object (required)
         'gtvc_category_loop_bg_color_control', //Set a unique ID for the control
         array(
            'label'      => __( 'Category Background Color', 'gtvc' ), //Admin-visible name of the control
            'settings'   => 'gtvc_category_loop_bg_color', //Which setting to load and manipulate (serialized is okay)
            'section'    => 'gtvc_category_options', //ID of the section this control should render in (can be one of yours, or a WordPress default section)
         ) 
      ) );


      //2. Category Grid Border Radius
      $wp_customize->add_setting( 'gtvc_category_loop_border_radius_top', //No need to use a SERIALIZED name, as `theme_mod` settings already live under one db record
         array(
            'default'    => '0px', //Default setting/value to save
            'capability' => 'edit_theme_options', //Optional. Special permissions for accessing this setting.
            'transport'  => 'refresh', //What triggers a refresh of the setting? 'refresh' or 'postMessage' (instant)?
         ) 
      );      
            
      //3. Finally, we define the control itself (which links a setting to a section and renders the HTML controls)...
      $wp_customize->add_control( 
         'gtvc_category_loop_border_radius_top_control', //Set a unique ID for the control
         array(
            'label'      => __( 'Border Radius Top', 'gtvc' ), //Admin-visible name of the control
            'settings'   => 'gtvc_category_loop_border_radius_top', //Which setting to load and manipulate (serialized is okay)
            'section'    => 'gtvc_category_options', //ID of the section this control should render in (can be one of yours, or a WordPress default section)
         ) 
      );

      //2. Category Grid Border Radius
      $wp_customize->add_setting( 'gtvc_category_loop_border_radius_bottom', //No need to use a SERIALIZED name, as `theme_mod` settings already live under one db record
         array(
            'default'    => '10px', //Default setting/value to save
            'capability' => 'edit_theme_options', //Optional. Special permissions for accessing this setting.
            'transport'  => 'refresh', //What triggers a refresh of the setting? 'refresh' or 'postMessage' (instant)?
         ) 
      );      
            
      //3. Finally, we define the control itself (which links a setting to a section and renders the HTML controls)...
      $wp_customize->add_control(
         'gtvc_category_loop_border_radius_bottom_control', //Set a unique ID for the control
         array(
            'label'      => __( 'Border Radius Bottom', 'gtvc' ), //Admin-visible name of the control
            'settings'   => 'gtvc_category_loop_border_radius_bottom', //Which setting to load and manipulate (serialized is okay)
            'section'    => 'gtvc_category_options', //ID of the section this control should render in (can be one of yours, or a WordPress default section)
         ) 
      );

   
       
       
       
    //Replace Lisense Manager Text / Lisense Key Text
      $wp_customize->add_section( 'gtvc_lisense_key_text_options', 
         array(
            'title'       => __( 'Replace Lisense Key / Card Info Text', 'gtvc' ), //Visible title of section
            'priority'    => 11, //Determines what order this appears in
            'capability'  => 'edit_theme_options', //Capability needed to tweak
            'description' => __('To Change Product Items & Grid Options', 'gtvc'), //Descriptive tooltip
            'panel'=>'gtvc_panel',
         ) 
      );

      $wp_customize->add_setting( 'gtvc_lisense_key_text_settings', //No need to use a SERIALIZED name, as `theme_mod` settings already live under one db record
         array(
            'default'    => 'Card/Key Info', //Default setting/value to save
            'capability' => 'edit_theme_options', //Optional. Special permissions for accessing this setting.
            'transport'  => 'refresh', //What triggers a refresh of the setting? 'refresh' or 'postMessage' (instant)?
         ) 
      );      
            
      $wp_customize->add_control( 'gtvc_lisense_key_text_control', array(
        'type' => 'text',
        'settings'   => 'gtvc_lisense_key_text_settings', 
        'section' => 'gtvc_lisense_key_text_options', // Add a default or your own section
        'label' => __( 'Replace Licesne Key Text', 'gtvc' ),
        ) );   
       
     
        //End Panel
      
   }

   /**
    * This will output the custom WordPress settings to the live theme's WP head.
    * 
    * Used by hook: 'wp_head'
    * 
    * @see add_action('wp_head',$func)
    * @since gtvc 1.0
    */
   public static function gtvc_customize_css() {
      ?>
      <!--Customizer CSS--> 
      <style type="text/css">
            /*product grid css*/
            h2.woocommerce-loop-product__title {
               color: <?php echo get_theme_mod('gtvc_product_loop_title_color','#000');?>;
            }
            .woocommerce ul.products li.product.ast-grid-common-col .ast-woo-product-category, .woocommerce ul.products li.ast-article-single.product .ast-woo-product-category{color: <?php echo get_theme_mod('gtvc_category_text_color','#000');?>; background-color: <?php echo get_theme_mod('gtvc_cat_text_bg_color','#ffd000');?>; }

            .woocommerce ul.products li.product.ast-grid-common-col, .woocommerce ul.products li.product.ast-article-single{border: <?php echo get_theme_mod('gtvc_product_loop_border_size','3');?>px solid <?php echo get_theme_mod('gtvc_product_loop_border_color','#ffd000');?>; border-radius: <?php echo get_theme_mod('gtvc_product_loop_border_radius');?>px; margin-bottom: <?php echo get_theme_mod('gtvc_product_loop_margin','10');?>px; background-color:<?php echo get_theme_mod('gtvc_product_loop_bg_color','#fff');?>;}

            .woocommerce ul.products, .woocommerce-page ul.products {
                column-gap: <?php echo get_theme_mod('gtvc_product_loop_margin','10');?>px;
            }

            .woocommerce ul.products li.product a img {
                border-radius: <?php echo get_theme_mod('gtvc_product_image_border_radius_top','10');?>px <?php echo get_theme_mod('gtvc_product_image_border_radius_top','10');?>px <?php echo get_theme_mod('gtvc_product_image_border_radius_bottom','0');?>px <?php echo get_theme_mod('gtvc_product_image_border_radius_bottom','0');?>px;
            }

            .woocommerce ul.products li.product.ast-grid-common-col .astra-shop-summary-wrap , .woocommerce ul.products li.ast-article-single.product .astra-shop-summary-wrap{
                padding: <?php echo get_theme_mod('gtvc_product_content_padding','10');?>px;
            }

            .woocommerce ul.products li.product a img, .woocommerce-page ul.products li.product a img {
                margin-bottom: 0;
            }

            /*Product Cetegory Grid*/
            h2.woocommerce-loop-category__title {
               color: <?php echo get_theme_mod('gtvc_category_loop_title_color','#000');?>;
            }
            .woocommerce ul.products li.product .woocommerce-loop-category__title .count, .woocommerce-page ul.products li.product .woocommerce-loop-category__title .count {
               opacity: 1;
               color: <?php echo get_theme_mod('gtvc_category_loop_count_color','#f40000');?>;
            }

            .woocommerce ul.products li.product .woocommerce-loop-category__title{
               position: relative;
               background-color: <?php echo get_theme_mod('gtvc_category_loop_bg_color','#FFD000');?>;
               text-align: center;
               left: 0;
               right: 0em; 
               padding: 0.5em 0 0.7em;
               top: 0;
               border-radius: <?php echo get_theme_mod('gtvc_category_loop_border_radius_top','0px');?> <?php echo get_theme_mod('gtvc_category_loop_border_radius_top','0px');?> <?php echo get_theme_mod('gtvc_category_loop_border_radius_bottom','10px');?> <?php echo get_theme_mod('gtvc_category_loop_border_radius_bottom','10px');?>;
            }


         </style>
      <!--/Customizer CSS-->
      <?php
   }

}

// Setup the Theme Customizer settings and controls...
add_action( 'customize_register' , array( 'GTVC_Customize' , 'register' ) );

// Output custom CSS to live site
add_action( 'wp_head' , array( 'GTVC_Customize' , 'gtvc_customize_css' ) );