<?php
// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) exit;

// BEGIN ENQUEUE PARENT ACTION
// AUTO GENERATED - Do not modify or remove comment markers above or below:

if ( !function_exists( 'chld_thm_cfg_locale_css' ) ):
    function chld_thm_cfg_locale_css( $uri ){
        if ( empty( $uri ) && is_rtl() && file_exists( get_template_directory() . '/rtl.css' ) )
            $uri = get_template_directory_uri() . '/rtl.css';
        return $uri;
    }
endif;
add_filter( 'locale_stylesheet_uri', 'chld_thm_cfg_locale_css' );
         
if ( !function_exists( 'child_theme_configurator_css' ) ):
    function child_theme_configurator_css() {
        wp_enqueue_style( 'chld_thm_cfg_child', trailingslashit( get_stylesheet_directory_uri() ) . 'style.css', array( 'astra-theme-css','woocommerce-layout','woocommerce-smallscreen','woocommerce-general' ) );
    }
endif;

add_action( 'wp_enqueue_scripts', 'child_theme_configurator_css', 10 );

// END ENQUEUE PARENT ACTION
// 


//Add Custom Script File
function gtv_custom_scripts() {
	wp_enqueue_script( 'gtv-custom-script', get_stylesheet_directory_uri() . '/js/custom-gtv.js', array(), '1.1.2', true );
}
add_action( 'wp_enqueue_scripts', 'gtv_custom_scripts' );

require_once 'inc/image-carousel.php';
require_once 'inc/load-customizer.php';



// CREATE WORDPRESS ACTION ON FOOTER
add_action('wp_footer', 'customJsScript_gtv_gaming');

function customJsScript_gtv_gaming() {
  echo "
  <script>
  window.addEventListener('DOMContentLoaded', function() {
jQuery(function($){
    jQuery('.thwvsf-wrapper-ul .thwvsf-wrapper-item-li .thwvsf-item-span').html(function (i, html) {
        return html.replace(/\-(.*$)/, ' <span class=\"gaming_topup_gt\">$1</span>')
    })
})
});
  </script>
  ";
}


// Show Social Login on My account  Page
if(class_exists('NextendSocialLogin', false)){
	function action_woocommerce_login_form(  ) { 
		echo NextendSocialLogin::renderButtonsWithContainer();
	}
	// add the action for nextend login
	add_action( 'woocommerce_login_form', 'action_woocommerce_login_form', 10, 0 ); 
	add_action('woocommerce_register_form', 'action_woocommerce_login_form');
};        


//Show Topup Wallet Amount on Checkout Page
if(function_exists('woo_wallet')){
function topup_system_in_checkout(){
echo 'Wallet Amount '.do_shortcode( '[mini-wallet]' );
}
add_action('woocommerce_review_order_before_payment','topup_system_in_checkout');
};


//Add Product Title & Short Description after Single Product Gallery Image
function after_single_product_image_sec(){
	echo "<br><h4>".get_the_title()."</h4>"."<p>".get_the_excerpt()."</p>";
}
add_action('woocommerce_product_thumbnails','after_single_product_image_sec');


//Back button for my account page


$current_url = (isset($_SERVER['HTTPS']) ? "https" : "http") . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
$dashboard_url = get_site_url().'/my-account/';

if($dashboard_url !== $current_url){
	
	function back_my_account_page_gctv(){	
		$dashboard_url = get_site_url().'/my-account/';
		echo '<a href="'.$dashboard_url.'" class="gtv_dashboard_back";><i class="fa fa-arrow-left" aria-hidden="true"></i> Back to Dashboard</a>'; 
	}
	add_action('woocommerce_account_navigation','back_my_account_page_gctv');

}
	
//Remove Some Checkout Fileds
add_filter( 'woocommerce_checkout_fields' , 'quadlayers_remove_checkout_fields' );
add_filter( 'woocommerce_enable_order_notes_field', '__return_false', 9999 );
function quadlayers_remove_checkout_fields( $fields ) {
	unset($fields['billing']['billing_address_2']);
	unset($fields['billing']['billing_city']);
	unset($fields['billing']['billing_company']);
	unset($fields['billing']['billing_postcode']);
	unset($fields['billing']['billing_state']);
	return $fields; 
}



// //Direct checkout & skip cart page
// add_filter('add_to_cart_redirect', 'ql_skip_cart_page');
// function ql_skip_cart_page () {
//  global $woocommerce;
//  $redirect_checkout = $woocommerce->cart->get_checkout_url();
//  return $redirect_checkout;
// }

// Function that skip cart redirecting to checkout
function skip_cart_page_redirection_to_checkout() {

    // If is cart page, redirect checkout.
    if( is_cart() )
         wp_redirect( wc_get_checkout_url() );
}
add_action('template_redirect', 'skip_cart_page_redirection_to_checkout');

//Replace Ad to cart text to Buy Now
add_filter( 'woocommerce_product_single_add_to_cart_text', 'ql_replace_add_to_cart_button_text' );
add_filter( 'woocommerce_product_add_to_cart_text', 'ql_replace_add_to_cart_button_text' );
//Replace Add to Cart text with Buy Now! 
function ql_replace_add_to_cart_button_text() {
 return __( 'Buy Now', 'woocommerce' );
}


//Allow Only One Iteams on Cart Page
function woo_cart_ensure_only_one_item( $cart_contents ) {
    return array( end( $cart_contents ) );
}
add_filter( 'woocommerce_cart_contents_changed', 'woo_cart_ensure_only_one_item' );
